/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.sql.impl.connector.infoschema.InfoSchemaTable;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.view.View;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TablesTable
extends InfoSchemaTable {
    private static final String NAME = "tables";
    private static final List<TableField> FIELDS = Arrays.asList(new TableField("table_catalog", QueryDataType.VARCHAR, false), new TableField("table_schema", QueryDataType.VARCHAR, false), new TableField("table_name", QueryDataType.VARCHAR, false), new TableField("table_type", QueryDataType.VARCHAR, false), new TableField("self_referencing_column_name", QueryDataType.VARCHAR, false), new TableField("reference_generation", QueryDataType.VARCHAR, false), new TableField("user_defined_type_catalog", QueryDataType.VARCHAR, false), new TableField("user_defined_type_schema", QueryDataType.VARCHAR, false), new TableField("user_defined_type_name", QueryDataType.VARCHAR, false), new TableField("is_insertable_into", QueryDataType.VARCHAR, false), new TableField("is_typed", QueryDataType.VARCHAR, false), new TableField("commit_action", QueryDataType.VARCHAR, false));
    private final String schema;
    private final Collection<Mapping> mappings;
    private final Collection<View> views;

    public TablesTable(String catalog, String schemaName, String schema, Collection<Mapping> mappings, Collection<View> views) {
        super(FIELDS, catalog, schemaName, NAME, (TableStatistics)new ConstantTableStatistics((long)views.size()));
        this.schema = schema;
        this.mappings = mappings;
        this.views = views;
    }

    @Override
    protected List<Object[]> rows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.views.size());
        for (Mapping m4 : this.mappings) {
            rows.add(new Object[]{this.catalog(), this.schema, m4.name(), "BASE TABLE", null, null, null, null, null, "YES", "NO", null});
        }
        for (View v : this.views) {
            rows.add(new Object[]{this.catalog(), this.schema, v.name(), "VIEW", null, null, null, null, null, "NO", "NO", null});
        }
        return rows;
    }
}

